<?php

declare(strict_types=1);

namespace NowPaymentsPlugin\Storefront\Controller;

use Shopware\Core\Framework\Routing\Annotation\RouteScope;
use Shopware\Core\System\SalesChannel\SalesChannelContext;
use Shopware\Storefront\Controller\StorefrontController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Shopware\Core\Checkout\Payment\PaymentService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use NowPaymentsPlugin\Util\DebugLog;
use Shopware\Core\Framework\DataAbstractionLayer\EntityRepositoryInterface;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Criteria;
use Shopware\Core\Framework\DataAbstractionLayer\Search\Filter\EqualsFilter;
use Shopware\Core\Checkout\Order\OrderStates;
use Shopware\Core\Checkout\Order\OrderEvents;
use Shopware\Core\Checkout\Payment\Exception\AsyncPaymentProcessException;
use Shopware\Core\Checkout\Order\Aggregate\OrderTransaction\OrderTransactionStateHandler;



/**
 * @RouteScope(scopes={"storefront"})
 */
class callbackController extends StorefrontController
{
    /**
     * @var PaymentService
     */
    private $paymentService;

    /**
     * @var DebugLog
     */
    private $debugLog;

    private $order_transactionRepository;
    private $stateMachineStateRepository;

    /**
     * @var OrderTransactionStateHandler
     */
    private $transactionStateHandler;


    function isJson($string)
    {
        json_decode($string);
        return (json_last_error() == JSON_ERROR_NONE);
    }

    public function __construct(
        PaymentService $paymentService,
        DebugLog $debugLog,
        EntityRepositoryInterface $order_transactionRepository,
        EntityRepositoryInterface $stateMachineStateRepository,
        OrderTransactionStateHandler $transactionStateHandler
    ) {
        $this->paymentService = $paymentService;
        $this->debugLog = $debugLog;
        $this->order_transactionRepository = $order_transactionRepository;
        $this->stateMachineStateRepository = $stateMachineStateRepository;
        $this->transactionStateHandler = $transactionStateHandler;
    }
    /**
     * @Route("/checkout/nowpayment/error", name="frontend.checkout.nowpayment.error", options={"seo"="false"},defaults={"csrf_protected"=false}, methods={"POST","GET"})
     */
    public function error(Request $request, SalesChannelContext $context)
    {

        $this->debugLog->forwardCopy('Responce , error', $request);

        $requestqueryaRRAY = array_replace($request->request->all(), $request->query->all());
        $requestContent = $request->getContent();
        $requestContent = $this->isJson($requestContent) ? json_decode($request->getContent(), true) : [];
        $requestqueryaRRAY = array_replace(['payment_status' => 'cancelled', 'message' => '', 'redirectURL' => '/', 'csrf_protected' => false], $requestqueryaRRAY, $requestContent);

        if (isset($requestqueryaRRAY['_sw_order'])) {
            $oStartus = 'SuccessAndWait';
        }

        $requestqueryaRRAY['message']  = '<h1 class="finish-header" style="color: red;">'
            . 'we faced some techinical error confirming your order.'
            . '</h1>'
            . '<h3 class="finish-header" style="color: red;">'
            . 'please contact Support with your order detail'
            . '</h3></h3>'
            . "<div class=\"container\" style=\"max-width: 700px;background: bisque;border-radius: 5px;padding: 10px;\"><pre>" . $requestqueryaRRAY['message'] . "</pre></div>";

        //$this->forwardToRoute( 'frontend.checkout.finish.page',  ['orderId' => $orderId, 'changedPayment' => true, 'paymentFailed' => true]  );

        return $this->renderStorefront('@NowPaymentsPlugin/callback/index.html.twig', $requestqueryaRRAY);
    }

    /**
     * @Route("/checkout/nowpayment/process", name="frontend.checkout.nowpayment.process", options={"seo"="false"},defaults={"csrf_protected"=false}, methods={"POST","GET"})
     */
    public function process(Request $request, SalesChannelContext $context)
    {

        $requestqueryaRRAY = array_replace($request->request->all(), $request->query->all());
        $requestContent = $request->getContent();
        $requestContent = $this->isJson($requestContent) ? json_decode($request->getContent(), true) : [];

        $requestqueryaRRAY = array_replace(['payment_status' => 'cancelled', 'message' => '', 'redirectURL' => '/', 'csrf_protected' => false], $requestqueryaRRAY, $requestContent);

        if (isset($requestqueryaRRAY['_sw_order']) && isset($requestqueryaRRAY['payment_status']) && isset($requestqueryaRRAY['purchase_id'])) {
            if ($requestqueryaRRAY['payment_status'] === 'finished' || $requestqueryaRRAY['payment_status'] === 'sending') {
                $this->finalizeTransaction($request, $context);
            }
        }

        if (isset($requestqueryaRRAY['_sw_order'])) {

            $oStartus = OrderStates::STATE_CANCELLED;
            $criteria = new Criteria([$requestqueryaRRAY['_sw_order']]);
            $data = $this->order_transactionRepository->search($criteria, $context->getContext());
            if ($data) {

                $oStartus = $data->first()->getStateMachineState()->getTechnicalName();
                $orderId = $data->first()->getOrderId();
                $requestqueryaRRAY = array_replace($requestqueryaRRAY, ['payment_status' => $oStartus]);
                if ($oStartus === 'paid') {
                    return $this->forwardToRoute('frontend.checkout.finish.page',  ['orderId' => $orderId]);
                }
            }
        }
        return $this->renderStorefront('@NowPaymentsPlugin/callback/index.html.twig', $requestqueryaRRAY);
    }

    /**
     * @Route("/checkout/nowpayment/process/check", name="frontend.checkout.nowpayment.process.check", options={"seo"="false"},defaults={"csrf_protected"=false}, methods={"POST"})
     */
    public function process_check(Request $request, SalesChannelContext $context)
    {
        try {
            $requestqueryaRRAY = array_replace($request->request->all(), $request->query->all());
            $requestContent = $request->getContent();
            $requestContent = $this->isJson($requestContent) ? json_decode($request->getContent(), true) : [];

            $requestqueryaRRAY = array_replace(['payment_status' => 'cancelled', 'message' => '', 'redirectURL' => '/', 'csrf_protected' => false], $requestqueryaRRAY, $requestContent);

            if (isset($requestqueryaRRAY['_sw_order'])) {
                $oStartus = OrderStates::STATE_CANCELLED;
                $criteria = new Criteria([$requestqueryaRRAY['_sw_order']]);
                $data = $this->order_transactionRepository->search($criteria, $context->getContext());
                if ($data) {
                    $oStartus = $data->first()->getStateMachineState()->getTechnicalName();
                    $orderId = $data->first()->getOrderId();
                    $requestqueryaRRAY = array_replace($requestqueryaRRAY, ['payment_status' => $oStartus]);
                    return new JsonResponse(['_sw_order'=>$requestqueryaRRAY['_sw_order'],'payment_status' => $oStartus]);
                }
            }
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        } catch (\Exception $e) {
            $this->debugLog->send('Error', $e->getMessage());
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        }
    }

    public function validatePayment(string $paymentID, string $paymentState)
    {
        //TODO:Coress refrence woth payment gateway 
        //curl --location --request GET 'https://api.nowpayments.io/v1/payment/5524759814' \
        //--header 'x-api-key: A7M40XV-CG1448Z-KVVED3G-NW3V0TK'
        return true;
    }

    /**
     * @Route("/checkout/nowpayment/callback", name="frontend.checkout.nowpayment.callback", defaults={"auth_required"=false,"csrf_protected"=false}, options={"seo"="false"}, methods={"POST","GET"})
     */
    public function finalizeTransaction(Request $request, SalesChannelContext $salesChannelContext): Response
    {

        $this->debugLog->forwardCopy('Responce , callback', $request);

        $requestqueryaRRAY = array_replace($request->request->all(), $request->query->all());
        $requestContent = $request->getContent();
        $requestContent = $this->isJson($requestContent) ? json_decode($request->getContent(), true) : [];
        $response = array_replace($requestqueryaRRAY, $requestContent);

        if (!isset($requestqueryaRRAY['_sw_order'])) {
            $this->debugLog->send('Error , callback , we dont have sw order', $response);
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        }
        if (!isset($response['payment_status'])) {
            $this->debugLog->send('Error , callback , we dont have payment status', $response);
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        }
        if (!isset($response['purchase_id'])) {
            $this->debugLog->send('Error , callback , we dont have purchase id', $response);
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);
        }
        try {
            $paymentState = $response['payment_status'];
            $paymentID = $response['purchase_id'];
            $context = $salesChannelContext->getContext();

            $oStartus = OrderStates::STATE_CANCELLED;
            $criteria = new Criteria([$requestqueryaRRAY['_sw_order']]);
            $transaction = $this->order_transactionRepository->search($criteria, $context);
            if ($transaction) {
                $oStartus = $transaction->first()->getStateMachineState()->getTechnicalName();
                $orderId = $transaction->first()->getOrderId();
                if ($oStartus === 'in_progress') {
                    if ($paymentState === 'finished' || $paymentState === 'sending') {
                        if ($this->validatePayment($paymentID, $paymentState)) {
                            $this->transactionStateHandler->paid($requestqueryaRRAY['_sw_order'], $context);
                            return $this->forwardToRoute('frontend.checkout.finish.page',  ['orderId' => $orderId]);
                        }
                    } else if ($paymentState === 'partially_paid') {
                        $this->transactionStateHandler->payPartially($requestqueryaRRAY['_sw_order'], $context);
                    } else if ($paymentState === 'failed' || $paymentState === 'refunded' || $paymentState === 'expired') {
                        $this->transactionStateHandler->fail($requestqueryaRRAY['_sw_order'], $context);
                        return $this->forwardToRoute('frontend.checkout.finish.page',  ['orderId' => $orderId]);
                    }
                }
            }
            return new JsonResponse(null, Response::HTTP_NO_CONTENT);


            // if (!isset($response['_sw_payment_token'])) {
            //     $this->debugLog->send('Error , callback , we dont have paymentToken', $response);
            //     return new JsonResponse(null, Response::HTTP_NO_CONTENT);
            // }else{
            //     $paymentTokenStruct = $this->paymentService->finalizeTransaction($response['_sw_payment_token'], $request, $salesChannelContext);
            //     if ($paymentTokenStruct->getFinishUrl()) {
            //         return new RedirectResponse($paymentTokenStruct->getFinishUrl());
            //     }
            // }


        } catch (\Exception $e) {
            $this->debugLog->send('Error', 'An error occurred during reading the gateway responce' . PHP_EOL . $e->getMessage());
        }
    }
}
