<?php 
namespace NP\NowPayments\Model;
 
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\App\RequestInterface;
use Magento\Sales\Model\Order;
use NP\NowPayments\Logger\Logger;
use NP\NowPayments\Helper\Data as NowPaymentHelper;
class IpnManagement {
    
    /**
     * @var \Magento\Framework\App\RequestInterface
     */
    
    protected $request;
    /**
     * @var \Magento\Sales\Model\OrderRepository
     */
    private $orderRepository;

    /**
     * @var Logger
     */
    private $log;

    /**
     * @var NowPaymentHelper
     */
    private $helper;
    
    /**
     * @var  \Magento\Framework\ObjectManagerInterface
     */
     
    private $_objectManager;
    
    
    
    /**
     * IpnManagement constructor.
     *
     * @param RequestInterface $request
     * @param \Magento\Sales\Model\OrderRepository $orderRepository
     * @param Logger $logger
     * @param NowPaymentHelper $helper
     */
    
    public function __construct(
    RequestInterface $request,
    \Magento\Sales\Model\OrderRepository $orderRepository,
    Logger $logger,
    NowPaymentHelper $helper,
     \Magento\Framework\ObjectManagerInterface $objectmanager){
        $this->request = $request;
        $this->orderRepository = $orderRepository;
        $this->log = $logger;
        $this->helper = $helper;
        $this->_objectManager = $objectmanager;
    }

	/**
	 * {@inheritdoc}
	 */
	public function getPost($param)
    {
        try{
            
           // $ipndata = $_POST;
        $ipndata = file_get_contents("php://input");
        $this->logInfo("Data Received " . $ipndata);
        $ipndata = json_decode($ipndata,true);
       
       
        $response = ['error' => false,'status' => '200','msg' => 'status updated'];
       
            if (!empty($ipndata)) {
                
            
                // Payment was successful, so update the order's state, send order email and move to the success page
                $order_id = (int)$ipndata['order_id'];
                if ($order = $this->orderRepository->get($order_id)) {
                    if ($order->getState() == Order::STATE_NEW || $order->getState() == 'pending') {
                        
                            if (strtoupper($ipndata['price_currency']) == $order->getBaseCurrencyCode()) {
                                if ($ipndata['price_amount'] >= $order->getBaseGrandTotal()) {
                                    $status = $ipndata['payment_status'];
                                    $this->updateStatus($status, $order,$ipndata);
                                    $order->save();
                                    $response = ['error' => false,'status' => '200','msg' => 'ipn updated'];
                                    return json_encode($response);
                                } else {
                                    $this->logInfo('Amount paid is less than order total!', $order);
                                    $response['msg'] = 'Amount paid is less than order total!';
                                }
                            
                        } else {
                            $this->logInfo('Currency code does not match!', $order);
                            $response['msg'] = 'Currency code does not match!';
                        }
                    } else {
                        $this->logInfo('Order is no longer new. (most likely IPN has already been processed)');
                        $response['msg'] = 'Order is no longer new. (most likely IPN has already been processed)';
                    }
                } else {
                    $this->logInfo('Could not load order with ID: ' . $order_id);
                     $response['msg'] = 'Could not load order with ID: ' . $order_id;
                }
        } else {
            $this->logInfo('Request is EMPTY');
            $response['msg'] = 'Request is EMPTY';
        }
        
        
        } catch(\Exception $e){
            $this->logInfo("Exception " . $e->getMessage());
            $response['msg'] = $e->getMessage();
        }
        return json_encode($response);
    }
	/**
     * @param $status
     * @param $order
     */
    private function updateStatus($status, $order,$ipndata)
    {
        //$this->logInfo("Updating status ",$order);
        if ($status == 'failed') {
            //canceled or timed out
            $order->cancel();
            $order->setState(
                ORDER::STATE_CANCELED,
                true,
                'NowPayments.io Payment Status: ' . $this->getRequest()->getParam(
                    'payment_status'
                )
            )->setStatus(ORDER::STATE_CANCELED);
            $order->save();
            $this->logInfo("Status Updated " . $status,$order);
        } else {
            if ($status == 'finished') {
                $str = 'NowPayments.io Payment Status: ' . $status . ' ';
                    foreach($ipndata as $key => $value){
                        $str.= ' ' . $key . ' => ' . $value . ' </br>';
                    }
                    $order->setState(
                    $this->helper->getGeneralConfig('status_order_paid')
                )->setStatus($this->helper->getGeneralConfig('status_order_paid'));
                $order->addCommentToStatusHistory($str,$this->helper->getGeneralConfig('status_order_paid'));
                $order->save();
              //$this->logInfo("Updating status " . $order->canInvoice());
                if($order->canInvoice()) {
                    
                    $invoice = $this->_objectManager->create('\Magento\Sales\Model\Service\InvoiceService')->prepareInvoice($order);
                    $invoice->setRequestedCaptureCase(\Magento\Sales\Model\Order\Invoice::CAPTURE_ONLINE);
                    $invoice->register();
                    //$invoice->save();
                    
                    $this->logInfo("created invoice " . $invoice->getId(),$order);
                    
                    $transactionSave = $this->_objectManager->create('\Magento\Framework\DB\Transaction')->addObject(
                        $invoice
                    )->addObject(
                        $order
                    );
                    $transactionSave->save();
                    $order->addStatusHistoryComment(
                        __('Notified customer about invoice #%1.', $invoice->getId())
                    )
                    ->setIsCustomerNotified(true)
                    ->save();
                     $this->_objectManager->create(
                        \Magento\Sales\Api\InvoiceManagementInterface::class
                    )->notify($invoice->getEntityId());
                }else{
                    $this->logInfo("Can not create invoice ",$order);
                }
                
                
                
                $this->logInfo("Status Updated " . $status,$order);
                
            } else{
                $str = 'NowPayments.io Payment Status: ' . $status . ' </br>';
                foreach($ipndata as $key => $value){
                    $str.= ' ' . $key . ' => ' . $value . ' </br>';
                }
                
                //order payment pending
               $order->addCommentToStatusHistory($str,$this->helper->getGeneralConfig('status_order_placed'));
                $order->save();
                $this->logInfo("Status Updated " . $status,$order);
            }
            
            
        }
    }

	/**
     * @param      $msg
     * @param null $order
     */
    private function logInfo($msg, $order = null)
    {
        if ($this->helper->getGeneralConfig('debug')) {
            $messsageString = '';
            if ($order !== null) {
                $messsageString = 'Order ID: ' . $order->getId();
            }
            $messsageString .= $msg;
            $this->log->info($messsageString);
        }

        return;
    }
}
